@echo off
rem -------------------------------------------------------------------
rem  setup.cmd
rem  1) Check if the D: drive exists; if not, print an error and exit.
rem  2) Switch to D:\ root.
rem  3) Check if "D:\Professional Workforce" exists; if not, create it.
rem     If creation fails, print an error and exit.
rem -------------------------------------------------------------------

rem 1) Check for drive D:
if not exist d:\ (
    echo Error: Drive D: does not exist.
    exit /b 1
)

rem 2) Switch to D:\ (use /d to change drive and directory)
cd /d d:\

rem 3) Ensure "D:\Professional Workforce" exists
if not exist "d:\Professional Workforce" (
    echo Creating directory "D:\Professional Workforce"…
    md "Professional Workforce"
    if errorlevel 1 (
        echo Error: Failed to create directory "D:\Professional Workforce".
        exit /b 1
    )
)

echo Directory "D:\Professional Workforce" is ready.
exit /b 0

